uniform float base<
    string label = "Base (0.0)";
    string widget_type = "slider";
    float minimum = -1.0;
    float maximum = 1.0;
    float step = 0.01;
> = 0.0;

uniform float amount<
    string label = "Amount (0.0)";
    string widget_type = "slider";
    float minimum = 0.0;
    float maximum = 2.0;
    float step = 0.01;
> = 0.0;

float4 rgb2yiq(float4 rgb) {
    float y = 0.30 * rgb.x + 0.59 * rgb.y + 0.11 * rgb.z;
    return float4(y, -0.27 * (rgb.z-y) + 0.74 * (rgb.x-y), 0.41 * (rgb.z-y) + 0.48 * (rgb.x-y), rgb.a);
}

float4 yiq2rgb(float4 yiq) {
    return float4(yiq.x + 0.9469*yiq.y + 0.6236*yiq.z, yiq.x - 0.2748*yiq.y - 0.6357*yiq.z, yiq.x - 1.1*yiq.y + 1.7*yiq.z, yiq.a);
}

float rand(float2 n) { 
    return fract(sin(dot(n, float2(12.9898, 4.1414))) * 43758.5453);
}

float4 mainImage(VertData v_in) : TARGET {
    float4 yiq1 = rgb2yiq(image.Sample(textureSampler, v_in.uv));
    float4 yiq2 = yiq1;
    yiq2.yz = mix(yiq1.yz, yiq1.zy, amount * rand_f + base);
    return yiq2rgb(yiq2);
}
