uniform float luma<
    string label = "Luma (1.0)";
    string widget_type = "slider";
    float minimum = 0.0;
    float maximum = 2.0;
    float step = 0.01;
> = 1.0;

uniform float chroma<
    string label = "Chroma (1.0)";
    string widget_type = "slider";
    float minimum = 0.0;
    float maximum = 2.0;
    float step = .01;
> = 1.0;

uniform float smear<
    string label = "Smear (0.0)";
    string widget_type = "slider";
    float minimum = 0.0;
    float maximum = 100.0;
    float step = 1.0;
> = 0.0;

uniform float sres<
    string label = "Sample res (320.0)";
    string widget_type = "slider";
    float minimum = 160.0;
    float maximum = 2560.0;
    float step = 1.0;
> = 320.0;

uniform float mixv<
    string label = "Smear mix (0.5)";
    string widget_type = "slider";
    float minimum = 0.0;
    float maximum = 1.0;
    float step = 0.01;
> = 0.5;

uniform float lmixv<
    string label = "Luma haze smear mix (0.5)";
    string widget_type = "slider";
    float minimum = 0.0;
    float maximum = 1.0;
    float step = 0.01;
> = 0.5;

uniform float lumah<
    string label = "Luma haze (0.0)";
    string widget_type = "slider";
    float minimum = 0.0;
    float maximum = 1.0;
    float step = 0.01;
> = 0.0;

uniform float lumahoff<
    string label = "Luma haze offset (0.5)";
    string widget_type = "slider";
    float minimum = 0.0;
    float maximum = 1.0;
    float step = 0.01;
> = 0.5;

uniform float lumahs<
    string label = "Luma haze smear (0.75)";
    string widget_type = "slider";
    float minimum = 0.0;
    float maximum = 1.0;
    float step = 0.01;
> = 0.75;

uniform float lumahb<
    string label = "Luma haze light bias (0.5)";
    string widget_type = "slider";
    float minimum = 0.0;
    float maximum = 1.0;
    float step = 0.01;
> = 0.5;

float4 rgb2yiq(float4 rgb) {
    float y = 0.30 * rgb.x + 0.59 * rgb.y + 0.11 * rgb.z;
    return float4(y, -0.27 * (rgb.z-y) + 0.74 * (rgb.x-y), 0.41 * (rgb.z-y) + 0.48 * (rgb.x-y), rgb.a);
}

float4 yiq2rgb(float4 yiq) {
    return float4(yiq.x + 0.9469*yiq.y + 0.6236*yiq.z, yiq.x - 0.2748*yiq.y - 0.6357*yiq.z, yiq.x - 1.1*yiq.y + 1.7*yiq.z, yiq.a);
}

float4 getpix(float2 coord) {
    if (coord.x < 0.0) {
        return float4(0.0, 0.0, 0.0, 1.0);
    }
    return image.Sample(textureSampler, coord);
}

float4 mainImage(VertData v_in) : TARGET {
    float4 pix = image.Sample(textureSampler, v_in.uv);
    float4 yiq2 = rgb2yiq(pix);
    int len = int(smear);
    pix = getpix(float2(v_in.uv.x - (1 / sres) * float(len), v_in.uv.y));
    float4 yiq = rgb2yiq(pix);
    for (int i = len - 1; i > -1; --i) {
        pix = getpix(float2(v_in.uv.x - (1 / sres) * float(i), v_in.uv.y));
        yiq = mix(yiq, rgb2yiq(pix), mixv);
    }
    len = int(smear * lumahs);
    pix = getpix(float2(v_in.uv.x - (1 / sres) * float(len), v_in.uv.y));
    float4 haze = rgb2yiq(pix);
    for (int i = len - 1; i > -1; --i) {
        pix = getpix(float2(v_in.uv.x - (1 / sres) * float(i), v_in.uv.y));
        haze.x = mix(haze.x, rgb2yiq(pix).x, lmixv);
    }
    haze.x = 1 - haze.x;
    yiq.x = yiq2.x + ((haze.x * lumah) - (lumah * lumahoff)) * mix(1 - yiq2.x, 1, lumahb);
    yiq.x *= luma;
    yiq.yz *= chroma;
    return yiq2rgb(yiq);
}
