/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import org.lwjgl.Sys;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class Config {
    private static kv gameSettings = null;
    private static Minecraft minecraft = null;
    private static float[] lightLevels = null;
    private static int iconWidthTerrain = 16;
    private static int iconWidthItems = 16;
    private static Map foundClassesMap = new HashMap();
    private static boolean fontRendererUpdated = false;
    private static File logFile = null;
    public static final Boolean DEF_FOG_FANCY = true;
    public static final Float DEF_FOG_START = Float.valueOf(0.2f);
    public static final Boolean DEF_OPTIMIZE_RENDER_DISTANCE = false;
    public static final Boolean DEF_OCCLUSION_ENABLED = false;
    public static final Integer DEF_MIPMAP_LEVEL = 0;
    public static final Integer DEF_MIPMAP_TYPE = 9984;
    public static final Float DEF_ALPHA_FUNC_LEVEL = Float.valueOf(0.1f);
    public static final Boolean DEF_LOAD_CHUNKS_FAR = false;
    public static final Integer DEF_PRELOADED_CHUNKS = 0;
    public static final Integer DEF_CHUNKS_LIMIT = 25;
    public static final Integer DEF_UPDATES_PER_FRAME = 3;
    public static final Boolean DEF_DYNAMIC_UPDATES = false;

    private Config() {
    }

    private static String getVersion() {
        return "OptiFine_1.7.3_HD_G";
    }

    private static void checkOpenGlCaps() {
        Config.log("");
        Config.log(Config.getVersion());
        Config.log("" + new Date());
        Config.log("OS: " + System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") version " + System.getProperty("os.version"));
        Config.log("Java: " + System.getProperty("java.version") + ", " + System.getProperty("java.vendor"));
        Config.log("VM: " + System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.info") + "), " + System.getProperty("java.vm.vendor"));
        Config.log("LWJGL: " + Sys.getVersion());
        Config.log("OpenGL: " + GL11.glGetString((int)7937) + " version " + GL11.glGetString((int)7938) + ", " + GL11.glGetString((int)7936));
        int ver = Config.getOpenGlVersion();
        String verStr = "" + ver / 10 + "." + ver % 10;
        Config.log("OpenGL Version: " + verStr);
        if (!GLContext.getCapabilities().OpenGL12) {
            Config.log("OpenGL Mipmap levels: Not available (GL12.GL_TEXTURE_MAX_LEVEL)");
        }
        if (!GLContext.getCapabilities().GL_NV_fog_distance) {
            Config.log("OpenGL Fancy fog: Not available (GL_NV_fog_distance)");
        }
        if (!GLContext.getCapabilities().GL_ARB_occlusion_query) {
            Config.log("OpenGL Occlussion culling: Not available (GL_ARB_occlusion_query)");
        }
    }

    public static boolean isFancyFogAvailable() {
        return GLContext.getCapabilities().GL_NV_fog_distance;
    }

    public static boolean isOcclusionAvailable() {
        return GLContext.getCapabilities().GL_ARB_occlusion_query;
    }

    private static int getOpenGlVersion() {
        if (!GLContext.getCapabilities().OpenGL11) {
            return 10;
        }
        if (!GLContext.getCapabilities().OpenGL12) {
            return 11;
        }
        if (!GLContext.getCapabilities().OpenGL13) {
            return 12;
        }
        if (!GLContext.getCapabilities().OpenGL14) {
            return 13;
        }
        if (!GLContext.getCapabilities().OpenGL15) {
            return 14;
        }
        if (!GLContext.getCapabilities().OpenGL20) {
            return 15;
        }
        if (!GLContext.getCapabilities().OpenGL21) {
            return 20;
        }
        if (!GLContext.getCapabilities().OpenGL30) {
            return 21;
        }
        if (!GLContext.getCapabilities().OpenGL31) {
            return 30;
        }
        if (!GLContext.getCapabilities().OpenGL32) {
            return 31;
        }
        if (!GLContext.getCapabilities().OpenGL33) {
            return 32;
        }
        if (!GLContext.getCapabilities().OpenGL40) {
            return 33;
        }
        return 40;
    }

    public static void setGameSettings(kv options) {
        if (gameSettings == null) {
            Config.checkOpenGlCaps();
        }
        gameSettings = options;
    }

    public static boolean isUseMipmaps() {
        int mipmapLevel = Config.getMipmapLevel();
        return mipmapLevel > 0;
    }

    public static int getMipmapLevel() {
        if (gameSettings == null) {
            return DEF_MIPMAP_LEVEL;
        }
        return Config.gameSettings.ofMipmapLevel;
    }

    public static int getMipmapType() {
        if (gameSettings == null) {
            return DEF_MIPMAP_TYPE;
        }
        if (Config.gameSettings.ofMipmapLinear) {
            return 9986;
        }
        return 9984;
    }

    public static boolean isUseAlphaFunc() {
        float alphaFuncLevel = Config.getAlphaFuncLevel();
        return alphaFuncLevel > DEF_ALPHA_FUNC_LEVEL.floatValue() + 1.0E-5f;
    }

    public static float getAlphaFuncLevel() {
        return DEF_ALPHA_FUNC_LEVEL.floatValue();
    }

    public static boolean isFogFancy() {
        if (!GLContext.getCapabilities().GL_NV_fog_distance) {
            return false;
        }
        if (gameSettings == null) {
            return false;
        }
        return Config.gameSettings.ofFogFancy;
    }

    public static float getFogStart() {
        if (gameSettings == null) {
            return DEF_FOG_START.floatValue();
        }
        return Config.gameSettings.ofFogStart;
    }

    public static boolean isOcclusionEnabled() {
        if (gameSettings == null) {
            return DEF_OCCLUSION_ENABLED;
        }
        return Config.gameSettings.h;
    }

    public static boolean isOcclusionFancy() {
        if (!Config.isOcclusionEnabled()) {
            return false;
        }
        if (gameSettings == null) {
            return false;
        }
        return Config.gameSettings.ofOcclusionFancy;
    }

    public static boolean isLoadChunksFar() {
        if (gameSettings == null) {
            return DEF_LOAD_CHUNKS_FAR;
        }
        return Config.gameSettings.ofLoadFar;
    }

    public static int getPreloadedChunks() {
        if (gameSettings == null) {
            return DEF_PRELOADED_CHUNKS;
        }
        return Config.gameSettings.ofPreloadedChunks;
    }

    public static void dbg(String s2) {
        System.out.println(s2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(String s2) {
        Config.dbg(s2);
        try {
            if (logFile == null) {
                logFile = new File(Minecraft.b(), "optifog.log");
                logFile.delete();
                logFile.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(logFile, true);
            OutputStreamWriter logFileWriter = new OutputStreamWriter((OutputStream)fos, "ASCII");
            try {
                logFileWriter.write(s2);
                logFileWriter.write("\n");
                logFileWriter.flush();
            }
            finally {
                logFileWriter.close();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static int getUpdatesPerFrame() {
        if (gameSettings != null) {
            return Config.gameSettings.ofChunkUpdates;
        }
        return 1;
    }

    public static boolean isDynamicUpdates() {
        if (gameSettings != null) {
            return Config.gameSettings.ofChunkUpdatesDynamic;
        }
        return true;
    }

    public static boolean isRainFancy() {
        if (Config.gameSettings.ofRain == 0) {
            return Config.gameSettings.j;
        }
        return Config.gameSettings.ofRain == 2;
    }

    public static boolean isWaterFancy() {
        if (Config.gameSettings.ofWater == 0) {
            return Config.gameSettings.j;
        }
        return Config.gameSettings.ofWater == 2;
    }

    public static boolean isRainOff() {
        return Config.gameSettings.ofRain == 3;
    }

    public static boolean isCloudsFancy() {
        if (Config.gameSettings.ofClouds == 0) {
            return Config.gameSettings.j;
        }
        return Config.gameSettings.ofClouds == 2;
    }

    public static boolean isCloudsOff() {
        return Config.gameSettings.ofClouds == 3;
    }

    public static boolean isTreesFancy() {
        if (Config.gameSettings.ofTrees == 0) {
            return Config.gameSettings.j;
        }
        return Config.gameSettings.ofTrees == 2;
    }

    public static boolean isGrassFancy() {
        if (Config.gameSettings.ofGrass == 0) {
            return Config.gameSettings.j;
        }
        return Config.gameSettings.ofGrass == 2;
    }

    public static int limit(int val, int min, int max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static float limit(float val, float min, float max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static boolean isAnimatedWater() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedWater != 2;
        }
        return true;
    }

    public static boolean isGeneratedWater() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedWater == 1;
        }
        return true;
    }

    public static boolean isAnimatedPortal() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedPortal;
        }
        return true;
    }

    public static boolean isAnimatedLava() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedLava != 2;
        }
        return true;
    }

    public static boolean isGeneratedLava() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedLava == 1;
        }
        return true;
    }

    public static boolean isAnimatedFire() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedFire;
        }
        return true;
    }

    public static boolean isAnimatedRedstone() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedRedstone;
        }
        return true;
    }

    public static boolean isAnimatedExplosion() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedExplosion;
        }
        return true;
    }

    public static boolean isAnimatedFlame() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedFlame;
        }
        return true;
    }

    public static boolean isAnimatedSmoke() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedSmoke;
        }
        return true;
    }

    public static float getAmbientOcclusionLevel() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAoLevel;
        }
        return 0.0f;
    }

    public static float fixAoLight(float light, float defLight) {
        if (lightLevels == null) {
            return light;
        }
        float level_0 = lightLevels[0];
        float level_1 = lightLevels[1];
        if (light > level_0) {
            return light;
        }
        if (defLight <= level_1) {
            return light;
        }
        float mul = 1.0f - Config.getAmbientOcclusionLevel();
        return light + (defLight - light) * mul;
    }

    public static void setLightLevels(float[] levels) {
        lightLevels = levels;
    }

    public static boolean callBoolean(String className, String methodName, Object[] params) {
        try {
            Class cls = Config.getClass(className);
            if (cls == null) {
                return false;
            }
            Method method = Config.getMethod(cls, methodName, params);
            if (method == null) {
                return false;
            }
            Boolean retVal = (Boolean)method.invoke(null, params);
            return retVal;
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return false;
        }
    }

    public static void callVoid(String className, String methodName, Object[] params) {
        try {
            Class cls = Config.getClass(className);
            if (cls == null) {
                return;
            }
            Method method = Config.getMethod(cls, methodName, params);
            if (method == null) {
                return;
            }
            method.invoke(null, params);
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
    }

    public static void callVoid(Object obj, String methodName, Object[] params) {
        try {
            if (obj == null) {
                return;
            }
            Class<?> cls = obj.getClass();
            if (cls == null) {
                return;
            }
            Method method = Config.getMethod(cls, methodName, params);
            if (method == null) {
                return;
            }
            method.invoke(obj, params);
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
    }

    public static Object getFieldValue(String className, String fieldName) {
        try {
            Class cls = Config.getClass(className);
            if (cls == null) {
                return null;
            }
            Field field = cls.getDeclaredField(fieldName);
            if (field == null) {
                return null;
            }
            Object value = field.get(null);
            return value;
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static Object getFieldValue(Object obj, String fieldName) {
        try {
            if (obj == null) {
                return null;
            }
            Class<?> cls = obj.getClass();
            if (cls == null) {
                return null;
            }
            Field field = cls.getField(fieldName);
            if (field == null) {
                return null;
            }
            Object value = field.get(obj);
            return value;
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return null;
        }
    }

    private static Method getMethod(Class cls, String methodName, Object[] params) {
        Method[] methods = cls.getMethods();
        for (int i2 = 0; i2 < methods.length; ++i2) {
            Method m2 = methods[i2];
            if (!m2.getName().equals(methodName) || m2.getParameterTypes().length != params.length) continue;
            return m2;
        }
        Config.dbg("No method found for: " + cls.getName() + "." + methodName + "(" + Config.arrayToString(params) + ")");
        return null;
    }

    public static String arrayToString(Object[] arr) {
        StringBuffer buf = new StringBuffer(arr.length * 5);
        for (int i2 = 0; i2 < arr.length; ++i2) {
            Object obj = arr[i2];
            if (i2 > 0) {
                buf.append(", ");
            }
            buf.append(String.valueOf(obj));
        }
        return buf.toString();
    }

    public static boolean hasModLoader() {
        Class cls = Config.getClass("ModLoader");
        return cls != null;
    }

    private static Class getClass(String className) {
        Class<?> cls = (Class<?>)foundClassesMap.get(className);
        if (cls != null) {
            return cls;
        }
        if (foundClassesMap.containsKey(className)) {
            return null;
        }
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e2) {
            Config.log("Class not found: " + className);
        }
        catch (Throwable e3) {
            e3.printStackTrace();
        }
        foundClassesMap.put(className, cls);
        return cls;
    }

    public static void setMinecraft(Minecraft mc2) {
        minecraft = mc2;
    }

    public static Minecraft getMinecraft() {
        return minecraft;
    }

    public static int getIconWidthTerrain() {
        return iconWidthTerrain;
    }

    public static int getIconWidthItems() {
        return iconWidthItems;
    }

    public static void setIconWidthItems(int iconWidth) {
        iconWidthItems = iconWidth;
    }

    public static void setIconWidthTerrain(int iconWidth) {
        iconWidthTerrain = iconWidth;
    }

    public static int getMaxDynamicTileWidth() {
        return 64;
    }

    public static int getSideGrassTexture(xp blockAccess, int x2, int y2, int z2, int side) {
        if (!Config.isBetterGrass()) {
            return 3;
        }
        if (Config.isBetterGrassFancy()) {
            --y2;
            switch (side) {
                case 2: {
                    --z2;
                    break;
                }
                case 3: {
                    ++z2;
                    break;
                }
                case 4: {
                    --x2;
                    break;
                }
                case 5: {
                    ++x2;
                }
            }
            int blockId = blockAccess.a(x2, y2, z2);
            if (blockId != 2) {
                return 3;
            }
        }
        return 0;
    }

    public static int getSideSnowGrassTexture(xp blockAccess, int x2, int y2, int z2, int side) {
        if (!Config.isBetterGrass()) {
            return 68;
        }
        if (Config.isBetterGrassFancy()) {
            switch (side) {
                case 2: {
                    --z2;
                    break;
                }
                case 3: {
                    ++z2;
                    break;
                }
                case 4: {
                    --x2;
                    break;
                }
                case 5: {
                    ++x2;
                }
            }
            int blockId = blockAccess.a(x2, y2, z2);
            if (blockId != 78 && blockId != 80) {
                return 68;
            }
        }
        return 66;
    }

    public static boolean isBetterGrass() {
        if (gameSettings == null) {
            return false;
        }
        return Config.gameSettings.ofBetterGrass != 3;
    }

    public static boolean isBetterGrassFancy() {
        if (gameSettings == null) {
            return false;
        }
        return Config.gameSettings.ofBetterGrass == 2;
    }

    public static boolean isFontRendererUpdated() {
        return fontRendererUpdated;
    }

    public static void setFontRendererUpdated(boolean fontRendererUpdated) {
        Config.fontRendererUpdated = fontRendererUpdated;
    }

    public static boolean isWeatherEnabled() {
        if (gameSettings == null) {
            return true;
        }
        return Config.gameSettings.ofWeather;
    }

    public static boolean isSkyEnabled() {
        if (gameSettings == null) {
            return true;
        }
        return Config.gameSettings.ofSky;
    }

    public static boolean isStarsEnabled() {
        if (gameSettings == null) {
            return true;
        }
        return Config.gameSettings.ofStars;
    }

    public static boolean isFarView() {
        if (gameSettings == null) {
            return false;
        }
        return Config.gameSettings.ofFarView;
    }

    public static void sleep(long ms2) {
        try {
            Thread.currentThread();
            Thread.sleep(ms2);
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
    }

    public static boolean isTimeDayOnly() {
        if (gameSettings == null) {
            return false;
        }
        return Config.gameSettings.ofTime == 1;
    }

    public static boolean isTimeNightOnly() {
        if (gameSettings == null) {
            return false;
        }
        return Config.gameSettings.ofTime == 2;
    }

    public static boolean isClearWater() {
        if (gameSettings == null) {
            return false;
        }
        return Config.gameSettings.ofClearWater;
    }
}

