/*
 * Decompiled with CFR 0.152.
 */
package ml.tcoded.nochatreports.listener;

import java.util.List;
import ml.tcoded.nochatreports.util.ComponentUtil;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

public class WhisperListener
implements Listener {
    private final List<String> whisperCommands = List.of("w", "tell", "msg");

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=false)
    public void onWhisperCmd(PlayerCommandPreprocessEvent event) {
        String rawMsg = event.getMessage();
        String[] parts = rawMsg.split(" ");
        if (parts.length < 3) {
            return;
        }
        String cmdPart = parts[0].substring(1).toLowerCase();
        String recipientPart = parts[1];
        String[] cmdParts = cmdPart.split(":");
        String msg = rawMsg.substring(cmdPart.length() + recipientPart.length() + 3);
        if (cmdParts.length == 1) {
            if (Bukkit.getPluginCommand((String)cmdPart) == null && this.isWhisperCmd(cmdPart)) {
                this.sendWhisperMsg(event.getPlayer(), cmdPart, recipientPart, msg);
                event.setCancelled(true);
            }
        } else if (cmdParts[0].equalsIgnoreCase("minecraft") && this.isWhisperCmd(cmdParts[1])) {
            this.sendWhisperMsg(event.getPlayer(), cmdParts[1], recipientPart, msg);
            event.setCancelled(true);
        }
    }

    private void sendWhisperMsg(Player sender, String alias, String recipient, String msg) {
        if (recipient.toLowerCase().startsWith("@e")) {
            ComponentBuilder builder = new ComponentBuilder();
            TextComponent errComp = new TextComponent("Only players may be affected by this command, but the provided selector includes entities\n");
            errComp.setColor(ChatColor.RED);
            errComp.setUnderlined(Boolean.valueOf(false));
            TextComponent errDetails = new TextComponent(alias + " " + recipient + " " + msg);
            errDetails.setColor(ChatColor.RED);
            errDetails.setUnderlined(Boolean.valueOf(true));
            TextComponent pointer = new TextComponent("<--[HERE]");
            pointer.setColor(ChatColor.RED);
            pointer.setUnderlined(Boolean.valueOf(false));
            pointer.setItalic(Boolean.valueOf(true));
            builder.append((BaseComponent)errComp);
            builder.append((BaseComponent)errDetails);
            builder.append((BaseComponent)pointer);
            sender.spigot().sendMessage(ChatMessageType.SYSTEM, builder.create());
            return;
        }
        List targets = Bukkit.selectEntities((CommandSender)sender, (String)recipient);
        if (targets.size() == 0) {
            TextComponent errComp = new TextComponent("No player was found");
            errComp.setColor(ChatColor.RED);
            sender.spigot().sendMessage(ChatMessageType.SYSTEM, (BaseComponent)errComp);
            return;
        }
        for (Entity entity : targets) {
            if (!(entity instanceof Player)) continue;
            Player target = (Player)entity;
            TextComponent senderComponent = ComponentUtil.createPlayerComponent(sender);
            TextComponent targetComponent = ComponentUtil.createPlayerComponent(target);
            TranslatableComponent senderMsg = new TranslatableComponent("commands.message.display.outgoing", new Object[]{targetComponent, msg});
            senderMsg.setColor(ChatColor.GRAY);
            senderMsg.setItalic(Boolean.valueOf(true));
            TranslatableComponent recipientMsg = new TranslatableComponent("commands.message.display.incoming", new Object[]{senderComponent, msg});
            recipientMsg.setColor(ChatColor.GRAY);
            recipientMsg.setItalic(Boolean.valueOf(true));
            sender.spigot().sendMessage(ChatMessageType.CHAT, target.getUniqueId(), (BaseComponent)senderMsg);
            target.spigot().sendMessage(ChatMessageType.CHAT, sender.getUniqueId(), (BaseComponent)recipientMsg);
        }
    }

    private boolean isWhisperCmd(String cmd) {
        return this.whisperCommands.contains(cmd.toLowerCase());
    }
}

